/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "myriexpress.h"
#include "test_common.h"

#define MAX_LEN  (1 << SIZE) /* 262144 */
#define SIZE     18

int main (void) { 
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  char send_buff[MAX_LEN];
  char recv_buff[MAX_LEN];
  int i;
  int len;
  mx_segment_t send_seg;
  mx_segment_t recv_seg;
  mx_request_t send_req[SIZE + 1];
  mx_request_t recv_req1;
  mx_request_t recv_req2;
  mx_status_t status;
  mx_return_t ret;
  uint32_t result;

  mx_set_error_handler(MX_ERRORS_RETURN);
  ret = mx_init();
  insist(ret == MX_SUCCESS);
  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);
  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  send_seg.segment_ptr = send_buff;
  recv_seg.segment_ptr = recv_buff;
  
  /* check in-order delivery of unexpected msgs */
  printf ("Test in-order delivery of unexpected msgs.\n");
  fflush(stdout);
  len = 80;
  send_seg.segment_length = len;
  recv_seg.segment_length = len;
  send_buff[0] = 'a';
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &send_req[0], 1000, &status, &result);
  insist((ret == MX_SUCCESS) 
	 && (status.code == MX_STATUS_SUCCESS)
	 && (result == 1));
  send_buff[0] = 'b';
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[1]);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &send_req[1], 1000, &status, &result);
  insist((ret == MX_SUCCESS) 
	 && (status.code == MX_STATUS_SUCCESS)
	 && (result == 1));
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req1);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &recv_req1, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(recv_buff[0] == 'a');
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req2);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &recv_req2, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1 ));
  insist(recv_buff[0] == 'b');

  /* check various size of unexpected msgs */
  printf ("Test various length of unexpected msgs.\n");
  fflush(stdout);
  for (i = 0, len = 1; len <= MAX_LEN; len *= 2, i ++) {
    insist(i <= SIZE);
    printf ("  %d\n", len);
    fflush(stdout);
    send_seg.segment_length = len;
    fill_data(send_buff, len);
    mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[i]);
  }

  for (len = 1; len <= MAX_LEN; len *= 2) {
    recv_seg.segment_length = len;
    ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req1);
    ret = mx_wait(ep, &recv_req1, MX_INFINITE, &status, &result);
    insist((ret == MX_SUCCESS) && (result == 1));
    check_data(recv_buff, len);
  }
  for (i = 0, len = 1; len <= MAX_LEN; len *= 2, i ++) {
    ret = mx_wait(ep, &send_req[i], MX_INFINITE, &status, &result);
    insist((ret == MX_SUCCESS) && (result == 1));
  }
  /* test 0-length message */
  printf ("Test 0-length msgs.\n");
  fflush(stdout);
  send_seg.segment_length = 0;
  recv_buff[0] = 'z';
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  ret = mx_wait(ep, &send_req[0], 1000, &status, &result);
  insist((ret == MX_SUCCESS) 
	 && (status.code == MX_STATUS_SUCCESS)
	 && (result == 1));
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req1);
  ret = mx_wait(ep, &recv_req1, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) 
	 && (status.code == MX_STATUS_SUCCESS)
	 && (result == 1));
  insist(recv_buff[0] == 'z');

  send_seg.segment_length = 0;
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  ret = mx_wait(ep, &send_req[0], 1000, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  send_buff[0]= 'a';
  send_seg.segment_length = 80;
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[1]);
  ret = mx_wait(ep, &send_req[1], 1000, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  recv_seg.segment_length = 40;
  recv_buff[0] = 'z';
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req1);
  ret = mx_wait(ep, &recv_req1, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.msg_length == 0);
  insist(status.xfer_length == 0);
  insist(recv_buff[0] == 'z');
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req2);
  ret = mx_wait(ep, &recv_req2, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(recv_buff[0] == 'a');
  insist(status.msg_length == 80);
  insist(status.xfer_length == 40);
  insist(status.code == MX_STATUS_TRUNCATED); 

  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req2);
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[1]);
  ret = mx_wait(ep, &recv_req2, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(recv_buff[0] == 'a');
  insist(status.msg_length == 80);
  insist(status.xfer_length == 40);
  insist(status.code == MX_STATUS_TRUNCATED); 
  ret = mx_wait(ep, &send_req[1], 1000, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));

  /* test unmatch filter key */

  /* test various length msgs */
  printf ("Test various length msgs.\n");
  fflush(stdout);
  for (len = 1; len <= MAX_LEN; len *= 2) {
    printf ("  %d\n", len);
    fflush(stdout);
    send_seg.segment_length = len;
    recv_seg.segment_length = len;
    fill_data(send_buff, len);

    mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
    ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req1);
    ret = mx_wait(ep, &recv_req1, MX_INFINITE, &status, &result);
    insist((ret == MX_SUCCESS) && (result == 1));
    ret = mx_wait(ep, &send_req[0], 1000, &status, &result);
    insist((ret == MX_SUCCESS) && (result == 1));

    check_data(recv_buff, len);
  }

  mx_finalize();
  printf("[PASS]\n");
  fflush(stdout);
  return 0;
}
